﻿{-# LANGUAGE OverloadedStrings #-}

module Photon.Resource.Index (
    -- * Index
    Index(..)
  , Entry(Entry)
  , entryName
  , entryType
  , entryDeps
  , Dependency(Dependency)
  , depPkg
  , depName
  , depType
    -- * Parsers
  ) where

import Control.Applicative
import Control.Monad ( mzero )
import Control.Lens ( makeLenses )
import Data.Aeson
import Data.Text ( Text )
import Photon.Resource.Type ( ResourceType(..) )

newtype Index = Index { unIndex :: [Entry] } deriving (Eq,Ord,Show)

data Entry = Entry {
    -- |
    _entryName :: Text
    -- |
  , _entryType :: ResourceType
    -- |
  , _entryDeps :: [Dependency]
  } deriving (Eq,Ord,Show)

data Dependency = Dependency {
    -- |
    _depPkg  :: Text
    -- |
  , _depName :: Text
    -- |
  , _depType :: Text
  } deriving (Eq,Ord,Show)

makeLenses ''Entry
makeLenses ''Dependency

instance FromJSON Dependency where
  parseJSON (Object v) =
      Dependency
        <$> v .: "pkg"
        <*> v .: "name"
        <*> v .: "type"
  parseJSON _ = mzero